/* Squirrel Script Tool for Simutrans
 * autor Andarix
 *
 * output stops with 80% waiting passengers (player and public)
 *
 */

function init(pl)
{
	return true
}

function work(pl, pos)
{
	local output_message = ""
	local output_message_coord = ""

	local stations_list = null
	local count = 0
  local max_message = false
  local max_message_coord = false

    local output_start = translate("stops with 80% waiting passengers (player and public):")

    foreach(station in halt_list_x()) {
			local count_waiting = station.get_waiting()
      local owner = station.get_owner()
		  local passenger_waiting = 0
      local pass_capacity = station.get_capacity(good_desc_x("Passagiere"))

			if ( station.get_connections(good_desc_x("Passagiere")).len() > 0 ) {
				local list = station.get_connections(good_desc_x("Passagiere"))
				if ( list.len() > 0 ) {
					foreach(target in list) {
						local tile_list = target.get_tile_list()
						passenger_waiting += station.get_freight_to_dest(good_desc_x("Passagiere"), tile_list[0])
						passenger_waiting += station.get_freight_to_halt(good_desc_x("Passagiere"), target)
					}

        }

        if ( (pass_capacity/5*4) <= passenger_waiting && (owner.nr == pl.nr || owner.nr == 1) ) {
					count++

			    local tile_list = station.get_tile_list()

          local message = "\n(" + station.get_name() + " (" + coord_to_string(square_x(tile_list[0].x, tile_list[0].y)) + "))"
          local message_coord = "(" + coord_to_string(square_x(tile_list[0].x, tile_list[0].y)) + ")"
          if ( count > 1 ) { message_coord = ", " + message_coord }

          local t = output_start + " (" + count + ")" + output_message + message
          local t_coord = output_start + " (" + count + ")" + output_message_coord + message_coord

          if ( t.len() < 250 && !max_message ) {
					  output_message += message
            output_message_coord += message_coord
          } else if ( t_coord.len() < 250 ) {
            output_message_coord += message_coord
            max_message = true
          } else if ( !max_message_coord ) {
            output_message = "\n" + output_message_coord + "\n..."
            max_message_coord = true
          }

          if ( max_message && !max_message_coord ) {
            output_message = "\n" + output_message_coord
          }

				}
			}

    }

		output_message = output_start + " (" + count + ")" + output_message

	return gui.add_message_at(pl, output_message, world.get_time())
}

function exit(pl)
{
	return true
}