
map.file = "empty-16x16.sve"

scenario.short_description = ""
scenario.author = ""
scenario.version = "0.1"

include("test_helpers")

map_siz <- world.get_size()
gl_tool_id <- null
step <- 1

function get_rule_text(pl)
{
	return ttext("")
}

function get_goal_text(pl)
{
	return ttextfile("")
}

function get_result_text(pl)
{
	local text = ttext("")

	return text.tostring()
}


function start()
{

}

function is_scenario_completed(pl)
{
	if(step == 1){
		test_way_road_build()
		step++
	}
	if(step == 2){
		test_way_road_build_forbid()
		step++
	}
	if(step == 3){
		test_way_road_build_allowed()
		step++
	}
	return 0
}

function is_work_allowed_here(pl, tool_id, name, pos, tool)
{
	return null
}

too_list <- [
				tool_build_way,
				tool_remover,
			]

function forbid_tools_map()
{
	for(local j=0; j<too_list.len(); j++) {
		rules.forbid_way_tool_rect(player_all, too_list[j], wt_all, "", coord(0, 0), coord(map_siz.x, map_siz.y), "Action Not Allowed")		
	}
}

function allow_tools_map()
{
	for(local j=0; j<too_list.len(); j++) {
		rules.allow_way_tool_rect(player_all, too_list[j], wt_all, "",coord(0, 0), coord(map_siz.x, map_siz.y))		
	}
}

function get_info_text(pl)
{
	local tx = ""
	return tx
}


function my_tile(coord)
{
	return square_x(coord.x,coord.y).get_ground_tile()
	//return square_x(coord.x,coord.y).get_tile_at_height(coord.z)
}

function test_way_road_build()
{
	local pl = player_x(0)
	local road_desc = way_desc_x.get_available_ways(wt_road, st_flat)[0]
	local default_cash = pl.get_current_cash()

	ASSERT_TRUE(road_desc != null)

	{
		ASSERT_EQUAL(command_x.build_way(pl, coord3d(4, 1, 0), coord3d(4, 3, 0), road_desc, true), null)
		local t = command_x(tool_remover)
		ASSERT_EQUAL(t.work(pl, coord3d(4, 2, 0), ""), null)
	}

}

function test_way_road_build_forbid()
{
	forbid_tools_map()
	local pl = player_x(0)
	local road_desc = way_desc_x.get_available_ways(wt_road, st_flat)[0]
	local default_cash = pl.get_current_cash()

	ASSERT_TRUE(road_desc != null)

	{
		ASSERT_EQUAL(command_x.build_way(pl, coord3d(4, 1, 0), coord3d(4, 3, 0), road_desc, true), "")
		local t = command_x(tool_remover)
		ASSERT_EQUAL(t.work(pl, coord3d(4, 1, 0), ""), "")

	}

}

function test_way_road_build_allowed()
{
	allow_tools_map()
	local pl = player_x(0)
	local road_desc = way_desc_x.get_available_ways(wt_road, st_flat)[0]
	local default_cash = pl.get_current_cash()

	ASSERT_TRUE(road_desc != null)

	{
		ASSERT_EQUAL(command_x.build_way(pl, coord3d(4, 1, 0), coord3d(4, 3, 0), road_desc, true), null)
		local t = command_x(tool_remove_way)
		ASSERT_EQUAL(t.work(pl, coord3d(4, 1, 0), coord3d(4, 3, 0), ""+wt_road), null)
	}

}


			
		
