function is_valid_pos(pl, pos, start)
{
	//print("is_valid_pos() called. " + pl.get_name() + "," + pos + ", " + start)
	return 2
}

/**
 * return error message
 */

pl_list <- {}
coor <- {}
all_list <- {}
sender.rect <- null


mark_list <- {}	//para marcar dinamicamente
tile_list <- {}	//crea una lista del rectangulo
w_list <- []	//lista para construir carreteras

function do_work(player, start, end)
{
	local t_a = tile_x(start.x, start.y, start.z)

	local tool = command_x(tool_remover)

	local l = min(start.x, end.x)
	local r = max(start.x, end.x)
	local b = min(start.y, end.y)
	local t = max(start.y, end.y)



	local result = message(check_list(player))
	
	if(result == null){
		coor = {x1 = l, y1 = b, x2 = r, y2 = t, list = all_list, type = "mark"}
		pl_list[player.id] <- coor
		sender.rect = pl_list
		send_data()
	}

	mark_list.clear()
	tile_list.clear()

	return result
}

/**
 * no return value
 */
function mark_tiles(pl, start, end)
{
	//print("mark_tiles() called. " + start + ", " + end)

	local l = min(start.x, end.x)
	local r = max(start.x, end.x)
	local b = min(start.y, end.y)
	local t = max(start.y, end.y)

	local list = {}
	local t_list = {}

	w_list = []
	// para el eje X
	w_list.push({c1 = my_tile(l,b), c2 = my_tile(r,b)})
	w_list.push({c1 = my_tile(l,t), c2 = my_tile(r,t)})

	//para el eje Y
	w_list.push({c1 = my_tile(l,b), c2 = my_tile(l,t)})
	w_list.push({c1 = my_tile(r,b), c2 = my_tile(r,t)})

	for(local x=l; x<=r; x++) {
		local t_a = square_x(x,b).get_ground_tile()
		local t_b = square_x(x,t).get_ground_tile()
		if (t_a && t_b) {

			t_list[coord3d_to_key(t_a)] <- t_a
			t_list[coord3d_to_key(t_b)] <- t_b

			local build_a = t_a.find_object(mo_building)
			local build_b = t_b.find_object(mo_building)

			if(build_a){
				build_a.mark()
				local res = {buil = build_a, t = t_a}
				list[coord3d_to_key(t_a)] <- res
			}
			if(build_b){
				build_b.mark()
				local res = {buil = build_b, t = t_b}
				list[coord3d_to_key(t_b)] <- res
			}
			mark_tile(t_a)
			mark_tile(t_b)
		}
	}
	for(local y=b; y<=t; y++) {
		local t_a = square_x(l,y).get_ground_tile()
		local t_b = square_x(r,y).get_ground_tile()
		if (t_a && t_b) {

			t_list[coord3d_to_key(t_a)] <- t_a
			t_list[coord3d_to_key(t_b)] <- t_b

			local build_a = t_a.find_object(mo_building)
			local build_b = t_b.find_object(mo_building)
			if(build_a){
				build_a.mark()
				local res = {buil = build_a, t = t_a}
				list[coord3d_to_key(t_a)] <- res
			}
			if(build_b){
				build_b.mark()
				local res = {buil = build_b, t = t_b}
				list[coord3d_to_key(t_b)] <- res
			}
			mark_tile(t_a)
			mark_tile(t_b)
		}
	}

	tile_list = t_list

	mark_unmark(list)
}

function my_tile(x,y)
{
	local t = square_x(x,y).get_ground_tile()
	return {x = t.x, y = t.y, z = t.z}
}

function mark_unmark(list){
	foreach(key, val in mark_list){
		local t = val.t
		try {
			list[coord3d_to_key(t)]
		}
		catch(ev) {
			val.buil.unmark()
		}
	}
	mark_list = list
}

function check_list(pl){

	local lock = false
	local res = {nr = 0, t = null}

	//Falla si el jugador es distinto a Public Service
	if(pl.id != 1){
		res = {nr = 4, t = null}
		lock = true
	}

	local rem_list = []
	foreach(key, t in tile_list){
		local buil = t.find_object(mo_building)
		if(buil){
			buil.unmark()
			rem_list.push({x = t.x, y = t.y, z = t.z})

			if(lock) continue

			if(buil.is_townhall()){
				res = {nr = 2, t = t}
				lock = true	
				continue
			}

			local cat_res = true
			try {
				buil.get_owner().id
			}
			catch(ev) {
				cat_res = false
			}
			if(cat_res){
				res = {nr = 3, t = t}
				lock = true	
			}
		}
		if(lock) continue

		local slpe = t.get_slope()
		local way = t.find_object(mo_way)
		if(way) continue

		if(slpe != 0){
			res = {nr = 1, t = t}
			lock = true
		}
	}
	if(!lock){
		//all_list = {r = rem_list, w = w_list}

		if( (w_list[0].c2.x - w_list[0].c1.x) < 3 || (w_list[2].c2.y - w_list[2].c1.y) < 3){
			return 	{nr = 5, t = null}
		}
		
		local tool = command_x(tool_remover)
		foreach(c in rem_list){
			tool.work(pl, c, "")
		}

		local sc_wall_name = "blockwall"
		tool= command_x(tool_build_way)


		local desc_list = way_desc_x.get_available_ways(wt_road, st_flat)
		foreach(desc in desc_list){
			local speed = desc.get_topspeed()
			if(speed>=40 && speed<=70){
				foreach(val in w_list){
					command_x.build_way(pl, val.c1, val.c2, desc, true)
					tool.set_flags(2)
					tool.work(pl, val.c1, val.c2, sc_wall_name)
				}
				break
			}
		}
	}

	return res
}

function message(val){
	switch (val.nr) {
		case 0:
			return null
			break
		case 1:
			return "It is not suitable terrain "+ "("+coord3d_to_string(val.t)+")."
			break

		case 2:
			return "This building is the town hall "+ "("+coord3d_to_string(val.t)+")."
			break

		case 3:
			return "This building is privately owned "+ "("+coord3d_to_string(val.t)+")."
			break

		case 4:
			return "Only public service can use this tool."
			break

		case 5:
			return ""
			break
	}
	return "???"
}

function coord3d_to_key(c)
{
	return ("coord3d_" + c.x + "_" + c.y + "_" + c.z).toalnum();
}

function exit(pl)
{
	return true
}
