map.file = "empty-16x16.sve"

scenario.short_description = ""
scenario.author = ""
scenario.version = "0.1"

include("test_helpers")

map_siz <- world.get_size()
gl_tool_id <- null
step <-1

function get_rule_text(pl)
{
	return ttext("")
}

function get_goal_text(pl)
{
	return ttextfile("")
}

function get_result_text(pl)
{
	local text = ttext("")

	return text.tostring()
}

function start()
{
}

function is_scenario_completed(pl)
{

	if(step == 1){
		forbid_tools_way_menu()
		step++
		return 0
	}
	if(step == 2){
		test_menu_way()
		step++
	}
	if(step == 3){
		test_way_road_build()
		step++
	}
	if(step == 4){
		test_way_road_remove()
		step++
	}
	return 0
}

function is_work_allowed_here(pl, tool_id, name, pos, tool)
{
	return null
}

//Add all tools with waytype here
tool_list <-	[
						tool_build_way,
						tool_build_bridge,
						tool_build_tunnel,
						tool_build_roadsign,
						tool_build_wayobj,
						tool_remove_way,
						tool_remove_wayobj,
						tool_build_station,
						tool_build_bridge,
						tool_build_depot,
						tool_build_transformer,

				]

wt_list <-	[wt_road, wt_rail, wt_water]

check_list <- {}

function is_tool_active(pl, tool_id, wt, name = "")
{
	check_list[tool_id+""+wt] <- {id = tool_id, wt = wt}
	return true
}

function forbid_tools_menu()
{
	for(local j=0; j<tool_list.len(); j++) {
		rules.forbid_tool(player_all, tool_list[j])
	}
}

function forbid_tools_way_menu()
{
	foreach(tool in tool_list) {
		foreach(wt in wt_list){
			rules.forbid_way_tool(player_all, tool, wt, "")
		}
	}
}

function test_way_road_build()
{
	forbid_tools_way_menu()
	local pl = player_x(0)
	local road_desc = way_desc_x.get_available_ways(wt_road, st_flat)[0]

	ASSERT_TRUE(road_desc != null)
	{
		ASSERT_EQUAL(command_x.build_way(pl, coord3d(4, 1, 0), coord3d(4, 3, 0), road_desc, true), "")
	}

	rules.clear()

	local rail_desc = way_desc_x.get_available_ways(wt_rail, st_flat)[0]
	ASSERT_TRUE(road_desc != null)
	{
		ASSERT_EQUAL(command_x.build_way(pl, coord3d(4, 1, 0), coord3d(4, 3, 0), rail_desc, true), null)
	}

}

function test_way_road_remove()
{
	forbid_tools_way_menu()
	local pl = player_x(0)
	ASSERT_EQUAL(command_x(tool_remove_way).work(pl, coord3d(4, 1, 0), coord3d(4, 3, 0), "" + wt_rail), "")

	rules.clear()

	ASSERT_EQUAL(command_x(tool_remove_way).work(pl, coord3d(4, 1, 0), coord3d(4, 3, 0), "" + wt_rail), null)
}

function test_menu_way()
{
	if(check_list.len() > 0){
	
		local no_wt = false
		local ok_wt = false
		foreach(key, val in check_list){
			//ASSERT_EQUAL((val.wt == wt_road), false)
			if(val.wt == wt_rail || val.wt == wt_road){
				no_wt = true
				throw "This waytype should not be available,  wt: "+val.wt+" tool_id: "+val.id
			}
			else{
				ok_wt = true
			}
		}
		ASSERT_EQUAL(no_wt, false)
		ASSERT_EQUAL(ok_wt, true)
		check_list = {}
		rules.clear()
	}
	else{
		throw "The list should not be empty."
	}
}

function get_info_text(pl)
{
	local tx = ""
	return tx
}	
