
function set_all_rules_static(pl, type)
{

	switch (type) {
		case 0:	//player not configured
			local wt_tool =	[	
								tool_build_way,
								tool_build_bridge,
								tool_build_tunnel,
								tool_build_roadsign,
								tool_build_wayobj,
								tool_remove_way,
								tool_remove_wayobj,
								tool_build_station,
								tool_build_bridge,
								tool_build_depot,
								tool_build_transformer
							]
			local nwt_tool =	[	tool_remover,
									tool_raise_land,
									tool_lower_land,
									tool_setslope,
									tool_restoreslope,
									4103, //Show Reservation
									tool_add_city,
									tool_make_stop_public,
									tool_plant_tree,
									tool_set_climate,
									tool_set_marker,
									tool_merge_stop,
									4127	//remplace stop
							]

			foreach(t in nwt_tool){
				rules.forbid_tool(pl, t)
			}
			foreach(t in wt_tool){
				foreach(wt in all_waytypes){
					rules.forbid_way_tool(pl, t, wt, "")
				}
				rules.forbid_way_tool(pl, t, 0, "")
			}
			break

		case 1:	//Patrician
			local wt_tool =	[	
								tool_build_way,
								tool_build_bridge,
								tool_build_tunnel,
								tool_build_roadsign,
								tool_build_wayobj,
								tool_remove_way,
								tool_remove_wayobj,
								tool_build_station,
								tool_build_bridge,
								tool_build_transformer
							]
			local nwt_tool =	[	tool_remover,
									tool_raise_land,
									tool_lower_land,
									tool_setslope,
									tool_restoreslope,
									4103, //Show Reservation
									tool_add_city,
									tool_make_stop_public,
									tool_plant_tree,
									tool_set_climate,
									tool_set_marker,
									tool_merge_stop,
									4127	//remplace stop
							]

			foreach(t in nwt_tool){
				rules.forbid_tool(pl, t)
			}
			foreach(t in wt_tool){
				foreach(wt in all_waytypes){
					rules.forbid_way_tool(pl, t, wt, "")
				}
				rules.forbid_way_tool(pl, t, 0, "")
			}
			break

		case 2:	//Demiurge
			local wt_tool =	[]
			local nwt_tool =	[
									tool_raise_land,
									tool_lower_land,
									tool_setslope,
									tool_restoreslope,
									4103, //Show Reservation
									tool_add_city,
									tool_plant_tree,
									tool_set_climate,
									tool_set_marker
							]

			foreach(t in nwt_tool){
				rules.forbid_tool(pl, t)
			}
			foreach(t in wt_tool){
				foreach(wt in all_waytypes){
					rules.forbid_way_tool(pl, t, wt, "")
				}
				rules.forbid_way_tool(pl, t, 0, "")
			}
			break
	}
}

gate_list <- []
sing_list <- []
function set_sing_list()
{
	foreach(wt in all_waytypes){
		local desc = sign_desc_x.get_available_signs(wt)
		foreach(sing in desc){
			if(sing.is_private_way()){
				gate_list.push(sing.get_name())
			}
			else{
				sing_list.push(sing.get_name())
			}
		}
	}
}


function set_all_rules_dynamic(pl, type)
{
	local clr_tool =	[	tool_remover,
							tool_raise_land,
							tool_lower_land,
							tool_setslope,
							tool_restoreslope,
							4103, //Show Reservation
							tool_add_city,
							tool_make_stop_public,
							tool_plant_tree,
							tool_set_climate,
							tool_set_marker,
							tool_merge_stop,
							4127	//remplace stop
				]
	local clr_wt_tool =	[	
							tool_build_way,
							tool_build_bridge,
							tool_build_tunnel,
							tool_build_roadsign,
							tool_build_wayobj,
							tool_remove_way,
							tool_remove_wayobj,
							tool_build_station,
							tool_build_bridge,
							tool_build_depot,
							tool_build_transformer
						]

	foreach(t in clr_tool){
		rules.clear_forbid_tool(pl, t)
	}
	foreach(t in clr_wt_tool){
		foreach(wt in all_waytypes){
			rules.clear_forbid_way_tool(pl, t, wt, "")
		}
	}
	//---------------------------------------------------------------------------------
	//---> Elves have starting access to ships and airplanes
	//---> Dwarves have starting access to trams and trains
	//---> Humans have a 50% discount for purchasing townships, road and electric
	//---> Goblins can disrupt traffic and have their townships isolated (by bollards), all control land tools and  gateway
	//---------------------------------------------------------------------------------
	local wt_list = {	[wt_road] = {},
						[wt_rail] = {},
						[wt_water] = {},
						[wt_monorail] = {},
						[wt_maglev] = {},
						[wt_tram] = {},
						[wt_narrowgauge] = {},
						[wt_air] = {},
						[wt_power] = {}
					}

	switch (type) {
		case 1:	//Elves
			local new_wt = [wt_water, wt_air]

			foreach(wt in new_wt){
				wt_list.rawdelete(wt)
			}

			local wt_tool =	[	
								tool_build_way,
								tool_build_bridge,
								tool_build_tunnel,
								tool_build_roadsign,
								tool_build_wayobj,
								tool_remove_way,
								tool_remove_wayobj,
								tool_build_station,
								tool_build_bridge,
								tool_build_depot,
								tool_build_transformer
							]
			local nwt_tool =	[	tool_remover,
									tool_raise_land,
									tool_lower_land,
									tool_setslope,
									tool_restoreslope,
									4103, //Show Reservation
									tool_add_city,
									tool_make_stop_public,
									tool_plant_tree,
									tool_set_climate,
									tool_set_marker,
									tool_merge_stop,
									4127	//remplace stop
							]

			foreach(t in nwt_tool){
				rules.forbid_tool(pl, t)
			}
			foreach(t in wt_tool){
				if(t == tool_build_roadsign){
					foreach(name in gate_list){
						foreach(wt in new_wt){
							rules.forbid_way_tool(pl, t, wt, name)
						}
					}
				}
				foreach(key, table in wt_list){
					rules.forbid_way_tool(pl, t, key, "")
				}
				rules.forbid_way_tool(pl, t, 0, "")
			}
			break

		case 2:	//Dwarves
			local new_wt = [wt_tram, wt_rail]

			foreach(wt in new_wt){
				wt_list.rawdelete(wt)
			}

			local wt_tool =	[	
								tool_build_way,
								tool_build_bridge,
								tool_build_tunnel,
								tool_build_roadsign,
								tool_build_wayobj,
								tool_remove_way,
								tool_remove_wayobj,
								tool_build_station,
								tool_build_bridge,
								tool_build_depot,
								tool_build_transformer
							]
			local nwt_tool =	[	tool_remover,
									tool_raise_land,
									tool_lower_land,
									tool_setslope,
									tool_restoreslope,
									4103, //Show Reservation
									tool_add_city,
									tool_make_stop_public,
									tool_plant_tree,
									tool_set_climate,
									tool_set_marker,
									tool_merge_stop,
									4127	//remplace stop
							]

			foreach(t in nwt_tool){
				rules.forbid_tool(pl, t)
			}
			foreach(t in wt_tool){
				if(t == tool_build_roadsign){
					foreach(name in gate_list){
						foreach(wt in new_wt){
							rules.forbid_way_tool(pl, t, wt, name)
						}
					}
				}
				foreach(key, table in wt_list){
					rules.forbid_way_tool(pl, t, key, "")
				}
				rules.forbid_way_tool(pl, t, 0, "")	
			}
			break

		case 3:	//Humans
			local new_wt = [wt_road, wt_power]

			foreach(wt in new_wt){
				wt_list.rawdelete(wt)
			}

			local wt_tool =	[	
								tool_build_way,
								tool_build_bridge,
								tool_build_tunnel,
								tool_build_roadsign,
								tool_build_wayobj,
								tool_remove_way,
								tool_remove_wayobj,
								tool_build_station,
								tool_build_bridge,
								tool_build_depot,
								tool_build_transformer
							]
			local nwt_tool =	[	tool_remover,
									tool_raise_land,
									tool_lower_land,
									tool_setslope,
									tool_restoreslope,
									4103, //Show Reservation
									tool_add_city,
									tool_make_stop_public,
									tool_plant_tree,
									tool_set_climate,
									tool_set_marker,
									tool_merge_stop,
									4127	//remplace stop
							]

			foreach(t in nwt_tool){
				rules.forbid_tool(pl, t)
			}
			foreach(t in wt_tool){
				if(t == tool_build_roadsign){
					foreach(name in gate_list){
						foreach(wt in new_wt){
							rules.forbid_way_tool(pl, t, wt, name)
						}
					}
				}
				foreach(key, table in wt_list){
					rules.forbid_way_tool(pl, t, key, "")
				}
				rules.forbid_way_tool(pl, t, 0, "")		
			}
			break

		case 4:	//Goblins
			local new_wt = []

			foreach(wt in new_wt){
				wt_list.rawdelete(wt)
			}

			local wt_tool =	[	
								tool_build_way,
								tool_build_bridge,
								tool_build_tunnel,
								tool_build_wayobj,
								tool_build_station,
								tool_build_bridge,
								tool_build_depot,
								tool_build_transformer
							]
			local nwt_tool =	[
									4103, //Show Reservation
									tool_add_city,
									tool_make_stop_public,
									tool_set_marker,
									tool_merge_stop,
									4127	//remplace stop
							]

			foreach(t in nwt_tool){
				rules.forbid_tool(pl, t)
			}
			foreach(t in wt_tool){
				foreach(key, table in wt_list){
					rules.forbid_way_tool(pl, t, key, "")
				}
				rules.forbid_way_tool(pl, t, 0, "")
			}
			break
	}
}
