
function forbid_tools_map()
{
	for(local j=0; j<tool_list.len(); j++) {
		rules.forbid_way_tool_rect(player_all, tool_list[j], wt_all, "", coord(0, 0), coord(map_siz.x, map_siz.y), "Action Not Allowed")		
	}
}

function allow_tools_map()
{
	for(local j=0; j<tool_list.len(); j++) {
		rules.allow_way_tool_rect(player_all, tool_list[j], wt_all, "", coord(0, 0), coord(map_siz.x, map_siz.y))		
	}
}

function forbid_tools_range(c, pl, msg = "Action Not Allowed")
{
	local tool_list =	[	
							tool_build_way, tool_build_bridge, tool_remover, tool_build_tunnel, tool_build_wayobj
							tool_build_station, tool_remove_way, tool_build_roadsign, tool_build_depot
						]
	for(local i = 2; i < 15; i++) {
		if(i != pl){
			foreach(t in tool_list){
				rules.forbid_way_tool_rect(i, t, wt_all, "", coord(c.x1, c.y1), coord(c.x2, c.y2), msg)
			}
		}
	}
}

function forbid_tools_range_pl(c, pl, msg = "Action Not Allowed")
{
	local tool_list =	[	
							tool_build_way, tool_build_bridge, tool_remover, tool_build_tunnel, tool_build_wayobj
							tool_build_station, tool_remove_way, tool_build_roadsign, tool_build_depot
						]

	foreach(t in tool_list){
		rules.forbid_way_tool_rect(pl, t, wt_all, "", coord(c.x1, c.y1), coord(c.x2, c.y2), msg)
	
	}
	
}

function allow_tools_range(c, pl)
{
	local tool_list = [tool_build_way, tool_build_bridge]
	for(local j=0; j<tool_list.len(); j++) {
		rules.allow_way_tool_rect(pl, tool_list[j], wt_all, "", coord(c.x1, c.y1), coord(c.x2, c.y2))		
	}
}

function remove_tools_range(c, pl)
{
	for(local j=0; j<tool_list.len(); j++) {
		rules.clear_way_tool_rect(pl, tool_list[j], wt_all, "", coord(c.x1, c.y1), coord(c.x2, c.y2))		
	}
}

function set_all_rules_static(pl, type)
{

	switch (type) {
		case 0:	//player not configured
			local wt_tool =	[	
								tool_build_way,
								tool_build_bridge,
								tool_build_tunnel,
								tool_build_roadsign,
								tool_build_wayobj,
								tool_remove_way,
								tool_remove_wayobj,
								tool_build_station,
								tool_build_bridge,
								tool_build_depot,
								tool_build_transformer
							]
			local nwt_tool =	[	tool_remover,
									tool_raise_land,
									tool_lower_land,
									tool_setslope,
									tool_restoreslope,
									4103, //Show Reservation
									tool_add_city,
									tool_make_stop_public,
									tool_plant_tree,
									tool_set_climate,
									tool_set_marker,
									tool_merge_stop,
									4127	//remplace stop
							]

			foreach(t in nwt_tool){
				rules.forbid_tool(pl, t)
			}
			foreach(t in wt_tool){
				foreach(wt in all_waytypes){
					rules.forbid_way_tool(pl, t, wt, "")
				}
				rules.forbid_way_tool(pl, t, 0, "")
			}
			break

		case 1:	//Patrician
			local wt_tool =	[	
								tool_build_way,
								tool_build_bridge,
								tool_build_tunnel,
								tool_build_roadsign,
								tool_build_wayobj,
								tool_remove_way,
								tool_remove_wayobj,
								tool_build_station,
								tool_build_bridge,
								tool_build_transformer
							]
			local nwt_tool =	[	tool_remover,
									tool_raise_land,
									tool_lower_land,
									tool_setslope,
									tool_restoreslope,
									4103, //Show Reservation
									tool_add_city,
									tool_make_stop_public,
									tool_plant_tree,
									tool_set_climate,
									tool_set_marker,
									tool_merge_stop,
									4127	//remplace stop
							]

			foreach(t in nwt_tool){
				rules.forbid_tool(pl, t)
			}
			foreach(t in wt_tool){
				foreach(wt in all_waytypes){
					rules.forbid_way_tool(pl, t, wt, "")
				}
				rules.forbid_way_tool(pl, t, 0, "")
			}
			break

		case 2:	//Demiurge
			local wt_tool =	[]
			local nwt_tool =	[
									tool_raise_land,
									tool_lower_land,
									tool_setslope,
									tool_restoreslope,
									4103, //Show Reservation
									tool_add_city,
									tool_plant_tree,
									tool_set_climate,
									tool_set_marker
							]

			foreach(t in nwt_tool){
				rules.forbid_tool(pl, t)
			}
			foreach(t in wt_tool){
				foreach(wt in all_waytypes){
					rules.forbid_way_tool(pl, t, wt, "")
				}
				rules.forbid_way_tool(pl, t, 0, "")
			}
			break
	}
}

gate_list <- []
sing_list <- []
function set_sing_list()
{
	foreach(wt in all_waytypes){
		local desc = sign_desc_x.get_available_signs(wt)
		foreach(sing in desc){
			if(sing.is_private_way()){
				gate_list.push(sing.get_name())
			}
			else{
				sing_list.push(sing.get_name())
			}
		}
	}
}

st_list <- []
function set_station_list()
{
	local wt = 0 

	local list = good_desc_list_x()
	foreach(good_desc in list) {
		local desc = building_desc_x.get_available_stations(building_desc_x.station_extension, wt, good_desc)
		foreach(st in desc){
			local name = st.get_name()
			local is_name = false
			foreach(val in st_list){
				if(val == name){
					is_name = true
				}
			}
			if(!is_name){
				st_list.push(name)
				//gui.add_message(name)
			}
		}
	}
}


function set_all_rules_dynamic(pl, type, pl_wt)
{

	rules.clear_player(pl)


	for(local i = 2; i < 15; i++){
		if(i!= pl){
			local rul = persistent.all_save[i].rules
			foreach(c in rul){
				forbid_tools_range_pl(c, pl, format("This place belongs to player '%s' , you cannot build here.", player_x(i).get_name()))
			}
		}
	}

	//---------------------------------------------------------------------------------
	//---> Elves have starting access to ships and airplanes
	//---> Dwarves have starting access to trams and trains
	//---> Humans have a 50% discount for purchasing townships, road and electric
	//---> Goblins can disrupt traffic and have their townships isolated (by bollards), all control land tools and  gateway
	//---------------------------------------------------------------------------------
	local wt_list = {	[wt_road] = {},
						[wt_rail] = {},
						[wt_water] = {},
						[wt_monorail] = {},
						[wt_maglev] = {},
						[wt_tram] = {},
						[wt_narrowgauge] = {},
						[wt_air] = {},
						[wt_power] = {}
					}

	switch (type) {
		case 1:	//Elves
			local new_wt = [wt_water, wt_air]


			foreach(wt in new_wt){
				wt_list.rawdelete(wt)
			}

			foreach(wt in pl_wt){
				wt_list.rawdelete(wt)
			}

			local wt_tool =	[	
								tool_build_way,
								tool_build_bridge,
								tool_build_tunnel,
								tool_build_roadsign,
								tool_build_wayobj,
								tool_remove_way,
								tool_remove_wayobj,
								tool_build_station,
								tool_build_bridge,
								tool_build_depot,
								tool_build_transformer
							]
			local nwt_tool =	[	tool_remover,
									tool_raise_land,
									tool_lower_land,
									tool_setslope,
									tool_restoreslope,
									4103, //Show Reservation
									tool_add_city,
									tool_make_stop_public,
									tool_plant_tree,
									tool_set_climate,
									tool_set_marker,
									tool_merge_stop,
									4127	//remplace stop
							]

			foreach(t in nwt_tool){
				rules.forbid_tool(pl, t)
			}
			foreach(t in wt_tool){
				//Para quitar gateway ------------------------------
				if(t == tool_build_roadsign){
					foreach(name in gate_list){
						rules.forbid_way_tool(pl, t, wt_all, name)
					}
				}
				//---------------------------------------------------

				//Para quitar ext building --------------------------
				if(t == tool_build_station){
					foreach(name in st_list){
						rules.forbid_way_tool(pl, t, wt_all, name)
					}
				}
				//---------------------------------------------------

				foreach(key, table in wt_list){
					rules.forbid_way_tool(pl, t, key, "")
				}
			}
			break

		case 2:	//Dwarves
			local new_wt = [wt_tram, wt_rail]

			foreach(wt in new_wt){
				wt_list.rawdelete(wt)
			}

			local wt_tool =	[	
								tool_build_way,
								tool_build_bridge,
								tool_build_tunnel,
								tool_build_roadsign,
								tool_build_wayobj,
								tool_remove_way,
								tool_remove_wayobj,
								tool_build_station,
								tool_build_bridge,
								tool_build_depot,
								tool_build_transformer
							]
			local nwt_tool =	[	tool_remover,
									tool_raise_land,
									tool_lower_land,
									tool_setslope,
									tool_restoreslope,
									4103, //Show Reservation
									tool_add_city,
									tool_make_stop_public,
									tool_plant_tree,
									tool_set_climate,
									tool_set_marker,
									tool_merge_stop,
									4127	//remplace stop
							]

			foreach(t in nwt_tool){
				rules.forbid_tool(pl, t)
			}
			foreach(t in wt_tool){

				//Para quitar gateway ------------------------------
				if(t == tool_build_roadsign){
					foreach(name in gate_list){
						rules.forbid_way_tool(pl, t, wt_all, name)
					}
				}
				//---------------------------------------------------

				//Para quitar ext building --------------------------
				if(t == tool_build_station){
					foreach(name in st_list){
						rules.forbid_way_tool(pl, t, wt_all, name)
					}
				}
				//---------------------------------------------------

				foreach(key, table in wt_list){
					rules.forbid_way_tool(pl, t, key, "")
				}
				//rules.forbid_way_tool(pl, t, 0, "")	
			}
			break

		case 3:	//Humans
			local new_wt = [wt_road, wt_power]

			foreach(wt in new_wt){
				wt_list.rawdelete(wt)
			}

			local wt_tool =	[	
								tool_build_way,
								tool_build_bridge,
								tool_build_tunnel,
								tool_build_roadsign,
								tool_build_wayobj,
								tool_remove_way,
								tool_remove_wayobj,
								tool_build_station,
								tool_build_bridge,
								tool_build_depot,
								tool_build_transformer
							]
			local nwt_tool =	[	tool_remover,
									tool_raise_land,
									tool_lower_land,
									tool_setslope,
									tool_restoreslope,
									4103, //Show Reservation
									tool_add_city,
									tool_make_stop_public,
									tool_plant_tree,
									tool_set_climate,
									tool_set_marker,
									tool_merge_stop,
									4127	//remplace stop
							]

			foreach(t in nwt_tool){
				rules.forbid_tool(pl, t)
			}
			foreach(t in wt_tool){

				//Para quitar gateway ------------------------------
				if(t == tool_build_roadsign){
					foreach(name in gate_list){
						rules.forbid_way_tool(pl, t, wt_all, name)
					}
				}
				//---------------------------------------------------

				//Para quitar ext building --------------------------
				if(t == tool_build_station){
					foreach(name in st_list){
						rules.forbid_way_tool(pl, t, wt_all, name)
					}
				}
				//---------------------------------------------------

				foreach(key, table in wt_list){
					rules.forbid_way_tool(pl, t, key, "")
				}
				//rules.forbid_way_tool(pl, t, 0, "")		
			}
			break

		case 4:	//Goblins
			local new_wt = []

			foreach(wt in new_wt){
				wt_list.rawdelete(wt)
			}

			local wt_tool =	[	
								tool_build_way,
								tool_build_bridge,
								tool_build_tunnel,
								tool_build_wayobj,
								tool_build_station,
								tool_build_bridge,
								tool_build_depot,
								tool_build_transformer
							]
			local nwt_tool =	[
									4103, //Show Reservation
									tool_add_city,
									tool_make_stop_public,
									tool_set_marker,
									tool_merge_stop,
									4127	//remplace stop
							]

			foreach(t in nwt_tool){
				rules.forbid_tool(pl, t)
			}
			foreach(t in wt_tool){
				foreach(key, table in wt_list){
					rules.forbid_way_tool(pl, t, key, "")
				}

				//Para quitar ext building --------------------------
				if(t == tool_build_station){
					foreach(name in st_list){
						rules.forbid_way_tool(pl, t, wt_all, name)
					}
				}
				//---------------------------------------------------
			}
			break
	}
}


