function is_valid_pos(pl, pos, start)
{
	//print("is_valid_pos() called. " + pl.get_name() + "," + pos + ", " + start)
	return 2
}

/**
 * return error message
 */

exit <- false
mark_list <- {}	//para marcar dinamicamente
tile_list <- {}	//crea una lista del rectangulo

function init(pl)
{
	return true
}

function do_work(player, start, end)
{

	local t_a = tile_x(start.x, start.y, start.z)

	local tool = command_x(tool_remover)

	local l = min(start.x, end.x)
	local r = max(start.x, end.x)
	local b = min(start.y, end.y)
	local t = max(start.y, end.y)

	local city_a = world.find_nearest_city(coord(l, b))
	local city_b = world.find_nearest_city(coord(r, t))

	local c_a = city_a.get_pos()
	local c_b = city_b.get_pos()

	local key_a = coord_to_key(c_a)
	local key_b = coord_to_key(c_b)

	if(key_a != key_b){
		mark_list = {}
		tile_list = {}
		return format("Two or more cities are too near: '%s' and '%s' (%s)", city_a.get_name(), city_b.get_name(),  c_a.tostring())
	}

	c_a = city_a.get_pos_nw()
	c_b = city_a.get_pos_se()

	local result = message(check_list(player))

	local c_lab = coord(l, b)
	local list = world.get_label_list()
	// list is now of type label_list_x
	foreach(label in list) {
		local c = label.get_pos()
		if( ( c.x >= (c_a.x-3) && c.y >= (c_a.y-3) ) && ( c.x <= (c_b.x+3) && c.y <= (c_b.y+3) ) ){
			local text = label.get_text()
			local ex = regexp("[0-9,]+")
			local list = split(text,",",true);
			if(ex.match(text) && list.len() == 4){
				c_lab = c//tile_x(c.x, c.y, c.z).remove_object(player, mo_label)		
			}
		}
	}


	// Permite solo su uso dentro de los limites de la ciudad
	if( ( l >= (c_a.x-3) && b >= (c_a.y-3) ) && ( r <= (c_b.x+3) && t <= (c_b.y+3) ) ){

		if((r-l) < 3 || (t - b) < 3){
			mark_list = {}
			tile_list = {}
			return ""
		}
		if(result == null){
			local lab = tile_x(c_lab.x, c_lab.y, 0).find_object(mo_label)
			if(lab){
				lab.set_text(coord(l, b).tostring()+","+coord(r, t).tostring())
			}
			else{
				label_x.create(c_lab, player, coord(l, b).tostring()+","+coord(r, t).tostring())
			}
			return null
		}
		mark_list = {}
		tile_list = {}
		return result

	}
	else{
		return format("You can only use this tool in one city, the nearest one is '%s' (%s).", city_a.get_name(),  city_a.get_pos().tostring())
	}

	return null
}

/**
 * no return value
 */
function mark_tiles(pl, start, end)
{
	//print("mark_tiles() called. " + start + ", " + end)

	local l = min(start.x, end.x)
	local r = max(start.x, end.x)
	local b = min(start.y, end.y)
	local t = max(start.y, end.y)

	local list = {}
	local t_list = {}

	for(local x=l; x<=r; x++) {
		local t_a = square_x(x,b).get_ground_tile()
		local t_b = square_x(x,t).get_ground_tile()
		if (t_a && t_b) {

			t_list[coord3d_to_key(t_a)] <- t_a
			t_list[coord3d_to_key(t_b)] <- t_b

			local build_a = t_a.find_object(mo_building)
			local build_b = t_b.find_object(mo_building)

			if(build_a){
				build_a.mark()
				local res = {buil = build_a, t = t_a}
				list[coord3d_to_key(t_a)] <- res
			}
			if(build_b){
				build_b.mark()
				local res = {buil = build_b, t = t_b}
				list[coord3d_to_key(t_b)] <- res
			}
			if((r-l) > 2 && (t - b) > 2){
				mark_tile(t_a)
				mark_tile(t_b)
			}
		}
	}
	for(local y=b; y<=t; y++) {
		local t_a = square_x(l,y).get_ground_tile()
		local t_b = square_x(r,y).get_ground_tile()
		if (t_a && t_b) {

			t_list[coord3d_to_key(t_a)] <- t_a
			t_list[coord3d_to_key(t_b)] <- t_b

			local build_a = t_a.find_object(mo_building)
			local build_b = t_b.find_object(mo_building)
			if(build_a){
				build_a.mark()
				local res = {buil = build_a, t = t_a}
				list[coord3d_to_key(t_a)] <- res
			}
			if(build_b){
				build_b.mark()
				local res = {buil = build_b, t = t_b}
				list[coord3d_to_key(t_b)] <- res
			}
			if((r-l) > 2 && (t - b) > 2){
				mark_tile(t_a)
				mark_tile(t_b)
			}
		}
	}

	tile_list = t_list

	mark_unmark(list)
}

function exit(pl)
{
	mark_list = {}
	tile_list = {}
	return true
}

function my_tile(x,y)
{
	local t = square_x(x,y).get_ground_tile()
	return {x = t.x, y = t.y, z = t.z}
}

function mark_unmark(list){
	foreach(key, val in mark_list){
		local t = val.t
		try {
			list[coord3d_to_key(t)]
		}
		catch(ev) {
			val.buil.unmark()
		}
	}
	mark_list = list
}

function check_list(pl){

	local lock = false
	local res = {nr = 0, t = null}
	if(tile_list.len() == 0)
		return {nr = null, t = null}

	//Falla si el jugador es distinto a Public Service
	/*if(pl.id != 1){
		res = {nr = 4, t = null}
		lock = true
	}*/


	local rem_list = []
	foreach(key, t in tile_list){
		local buil = t.find_object(mo_building)
		if(buil){
			buil.unmark()
			rem_list.push({x = t.x, y = t.y, z = t.z})

			if(lock) continue

			if(buil.is_townhall()){
				res = {nr = 2, t = t}
				lock = true	
				continue
			}

			local cat_res = true
			try {
				buil.get_owner().id
			}
			catch(ev) {
				cat_res = false
			}
			if(cat_res){
				res = {nr = 3, t = t}
				lock = true	
			}
		}
		if(lock) continue

		local slpe = t.get_slope()
		local way = t.find_object(mo_way)
		if(way) continue

		/*
		if(slpe != 0){
			res = {nr = 1, t = t}
			lock = true
		}
		*/
	}
	return res
}

function message(val){
	mark_list = {}
	tile_list = {}
	switch (val.nr) {
		case 0:
			return null
			break
		case 1:
			return "It is not suitable terrain "+ "("+coord3d_to_string(val.t)+")."
			break

		case 2:
			return "This building is the town hall "+ "("+coord3d_to_string(val.t)+")."
			break

		case 3:
			return "This building is privately owned "+ "("+coord3d_to_string(val.t)+")."
			break

		case 4:
			return "Only public service can use this tool."
			break
	}
	return ""
}

function coord3d_to_key(c)
{
	return ("coord3d_" + c.x + "_" + c.y + "_" + c.z).toalnum();
}

function coord_to_key(c)
{
	return ("coord_" + c.x + "_" + c.y).toalnum();
}
