map.file = "empty-16x16.sve"

scenario.short_description = ""
scenario.author = ""
scenario.version = "0.1"

include("test_helpers")

step <-1

function get_rule_text(pl)
{
	return ttext("")
}

function get_goal_text(pl)
{
	return ttextfile("")
}

function get_result_text(pl)
{
	local text = ttext("")

	return text.tostring()
}

function start()
{

}

tool_total <- 0
function is_scenario_completed(pl)
{
	// tools with waytype ---------------------------------------------------
	if(step == 1){
		if(check_list.len() == 0){
			return 0
		}
		else {
			tool_total = check_list.len()
			foreach(tool in tool_list) {
				try{
					check_list[tool].id
				}
				catch(ev) {
					throw "The tool_id is not available: "+tool

				}
			}
		}

		check_list_wt.clear()
		forbid_tools_way_menu()
		step++
		return 0
	}
	if(step == 2){
		//gui.add_message(""+check_list_wt.len())
		if(check_list_wt.len() == 0){
			return 0
		}
		test_menu_way()
		step++
	}
	//--------------------------------------------------

	// all tools with waytype ---------------------------------------------------
	if(step == 3){
		check_list_wt.clear()
		forbid_tools_all_way_menu()
		step++
		return 0
	}
	if(step == 4){
		//gui.add_message(""+check_list_wt.len())
		if(check_list_wt.len() == 0){
			return 0
		}
		test_menu_all_way()
		step++
	}
	//--------------------------------------------------

	// tools without waytype----------------------------
	if(step == 5){

		check_list.clear()
		forbid_tools_menu()
		step++
		return 0
	}
	if(step == 6){
		if(check_list.len() == 0){
			return 0
		}
		test_menu()
		step++
	}
	//----------------------------------------------------

	if(step == 7){
		test_forbid_way_and_rect()
		step++
	}

	if(step == 8){
		test_way_road_build()
		step++
	}

	if(step == 9){
		test_way_road_remove()
		step++
	}



	if(step == 11){
		rules.clear()
		test_forbid_way_player()()
		step++
		return 0
	}

	return 0
}

function is_work_allowed_here(pl, tool_id, name, pos, tool)
{
	return null
}

//Add all tools with waytype here
tool_list_wt <-	[
						tool_build_way,
						tool_build_bridge,
						tool_build_tunnel,
						tool_build_roadsign,
						tool_build_wayobj,
						tool_remove_way,
						tool_remove_wayobj,
						tool_build_station,
						tool_build_bridge,
						tool_build_depot,
						tool_build_transformer,

				]

//Add all tools witout waytype here
tool_list <-	[	tool_remover,
					4103, //Show Reservation
					tool_make_stop_public,
					tool_plant_tree,
					tool_set_climate,
					tool_set_marker,
					tool_merge_stop,
					4127	//remplace stop
				]

wt_list <-	[wt_road, wt_rail, wt_water]

check_list_wt <- {}
check_list <- {}

function is_tool_active(pl, tool_id, wt, name = "")
{
	check_list_wt[tool_id+""+wt] <- {id = tool_id, wt = wt}

	if(wt < 0){
		check_list[tool_id] <- {id = tool_id, wt = wt}
	}
	return true
}

function forbid_tools_menu()
{
	foreach(tool in tool_list) {
		rules.forbid_tool(player_all, tool)
	}
}

function forbid_tools_way_menu()
{
	foreach(tool in tool_list_wt) {
		foreach(wt in wt_list){
			rules.forbid_way_tool(player_all, tool, wt, "")
		}
	}
}

function forbid_tools_all_way_menu()
{
	foreach(tool in tool_list_wt) {
		rules.forbid_way_tool(player_all, tool, wt_all, "")
	}
}

function forbid_tools_way_all()
{
	local list =	[

						tool_build_bridge,
						tool_build_tunnel,
						tool_build_roadsign,
						tool_build_wayobj,
						tool_remove_way,
						tool_remove_wayobj,
						tool_build_station,
						tool_build_bridge,
						tool_build_depot,
						tool_build_transformer,

				]
	foreach(tool in list) {
		rules.forbid_way_tool(player_all, tool, wt_all, "")
	}
}

function forbid_tools_way_all_rect()
{
	local list =	[
						tool_build_way,
						tool_build_bridge,
						tool_build_tunnel,


				]
	local c = {a = coord(0,0), b = coord(5,5)}
	foreach(tool in list) {
		rules.forbid_way_tool_rect(player_all, tool, wt_all, "", c.a, c.b, "Action Not Allowed")
	}
}


function forbid_tools_way_rect_pl()
{
	
	local wt_list = 	[wt_road, wt_rail, wt_water, wt_monorail, wt_maglev, wt_tram, wt_narrowgauge, wt_air, wt_power]

	local wt_tool =	[	
						tool_build_way,
						tool_build_bridge,
						tool_build_tunnel,
						tool_build_wayobj,
						tool_build_station,
						tool_build_bridge,
						tool_build_depot,
						tool_build_transformer
					]
	local nwt_tool =	[
							4103, //Show Reservation
							tool_add_city,
							tool_make_stop_public,
							//tool_set_marker,
							tool_merge_stop,
							4127	//remplace stop
					]
	foreach(t in nwt_tool){
		rules.forbid_tool(0, t)
	}
	foreach(t in wt_tool){
		foreach(wt in wt_list){
			rules.forbid_way_tool(0, t, wt, "")
		}
	}		

	local list =	[	
								tool_build_way,
								tool_build_bridge,
								tool_build_tunnel,
								tool_build_roadsign,
								tool_build_wayobj,
								tool_remove_way,
								tool_remove_wayobj,
								tool_build_station,
								tool_build_bridge,
								tool_build_depot,
								tool_build_transformer,
								tool_remover,
								tool_raise_land,
								tool_lower_land,
								tool_change_water_height,
								tool_setslope,
								tool_restoreslope,
								tool_add_city,
								tool_make_stop_public,
								tool_plant_tree,
								tool_set_climate,
								tool_set_marker,
								tool_merge_stop,
								4127	//remplace stop
					]
	local c = {a = coord(0,0), b = coord(5,5)}
	foreach(tool in list) {
		rules.forbid_way_tool_rect(0, tool, wt_all, "", c.a, c.b, "Action Not Allowed")
	}
}




function test_way_road_build()
{
	forbid_tools_way_menu()
	local pl = player_x(0)
	local road_desc = way_desc_x.get_available_ways(wt_road, st_flat)[0]

	ASSERT_TRUE(road_desc != null)
	{
		ASSERT_EQUAL(command_x.build_way(pl, coord3d(4, 1, 0), coord3d(4, 3, 0), road_desc, true), "")
	}


	rules.clear()

	local rail_desc = way_desc_x.get_available_ways(wt_rail, st_flat)[0]
	ASSERT_TRUE(road_desc != null)
	{
		ASSERT_EQUAL(command_x.build_way(pl, coord3d(4, 1, 0), coord3d(4, 3, 0), rail_desc, true), null)
	}
}

function test_way_road_remove()
{
	forbid_tools_way_menu()
	local pl = player_x(0)
	ASSERT_EQUAL(command_x(tool_remove_way).work(pl, coord3d(4, 1, 0), coord3d(4, 3, 0), "" + wt_rail), "")

	rules.clear()

	ASSERT_EQUAL(command_x(tool_remove_way).work(pl, coord3d(4, 1, 0), coord3d(4, 3, 0), "" + wt_rail), null)
}

function test_menu_way()
{
	//gui.add_message(""+ wt_rail + " "+wt_road)
	if(check_list_wt.len() > 0){
		foreach(key, val in check_list_wt){
			//ASSERT_EQUAL((val.wt == wt_road), false)
			if(val.wt == wt_rail || val.wt == wt_road){
				throw "This waytype should not be available,  wt: "+val.wt+" tool_id: "+val.id
			}
		}
		check_list_wt = {}
		rules.clear()
	}
	else{
		throw "The list should not be empty."
	}
}

function test_menu_all_way()
{
	//gui.add_message(""+ wt_rail + " "+wt_road)
	if(check_list_wt.len() > 0){
		foreach(key, val in check_list_wt){
			//ASSERT_EQUAL((val.wt == wt_road), false)
			if(val.wt != -1){
				throw "This waytype should not be available,  wt: "+val.wt+" tool_id: "+val.id
			}
		}
		check_list_wt = {}
		rules.clear()
	}
	else{
		throw "The list should not be empty."
	}
}

function test_menu()
{
	//gui.add_message(""+ wt_rail + " "+wt_road)
	local nr = tool_total - tool_list.len()
	if(nr != check_list.len())
		throw "The number of tools counted is not correct,  expected: "+nr+ "  currently: "+check_list.len()
}

function test_forbid_way_and_rect()
{
	forbid_tools_way_all()
	local pl = player_x(0)
	local road_desc = way_desc_x.get_available_ways(wt_road, st_flat)[0]
	ASSERT_TRUE(road_desc != null)
	{
		ASSERT_EQUAL(command_x.build_way(pl, coord3d(10, 10, 0), coord3d(12, 10, 0), road_desc, true), null)
	}

	forbid_tools_way_all_rect()
	ASSERT_EQUAL(command_x(tool_remove_way).work(pl, coord3d(10, 10, 0), coord3d(12, 10, 0), "" + wt_road), "")

	rules.clear()
	ASSERT_EQUAL(command_x(tool_remove_way).work(pl, coord3d(10, 10, 0), coord3d(12, 10, 0), "" + wt_road), null)
	
}

function test_forbid_way_player()
{
	forbid_tools_way_rect_pl()

	ASSERT_EQUAL(command_x.set_slope(pl, my_tile(coord(1,1)), slope.all_up_slope), "")

}

function get_info_text(pl)
{
	local tx = ""
	return tx
}	

function my_tile(coord)
{
	return square_x(coord.x,coord.y).get_ground_tile()
	//return square_x(coord.x,coord.y).get_tile_at_height(coord.z)
}
