
function init(pl)
{
  return true
}

/**
 * return error message
 */
function work(pl, pos)
{

  local tile = tile_x(pos.x, pos.y, pos.z)
  local speed_old = null
  local wt = null

  if ( tile.find_object(mo_way) != null ) {
    speed_old = tile.find_object(mo_bridge).get_desc().get_topspeed()
    wt = tile.find_object(mo_way).get_desc().get_waytype()
  }
  //gui.add_message_at(pl, coord3d_to_string(tile) + " speed_old  " + speed_old, world.get_time())

  if ( tile.is_bridge() ) {

    // check player
    if ( tile.find_object(mo_way) != null && tile.find_object(mo_way).get_owner().nr != pl.nr && tile.find_object(mo_way).get_owner().nr != 1 ) {
      local output_message = translate("Der Besitzer erlaubt das Entfernen nicht")
      return gui.add_message_at(pl, output_message, world.get_time())
    }

    // find bridge start and end
    local d = tile.get_way_dirs(wt)

    local dir_x = (d == dir.east || d == dir.west || d == dir.eastwest) ? 1 : 0
    local dir_y = (d == dir.north || d == dir.south || d == dir.northsouth) ? 1 : 0

    local bridge_coord = []
    local catenary_coord = []
    local sign_pos = []
    local sign_desc = tile.find_object(mo_signal)
    if ( sign_desc != null && tile.is_bridge() ) {
      local sign_data = []
      sign_data.append(tile)
      // ribi
      sign_data.append(tile.get_way_dirs_masked(wt))
      // signal
      sign_data.append(sign_desc.get_desc())

      sign_pos.append(sign_data)
    }

    local bridge_stations = []
    if ( tile.find_object(mo_building) != null && tile.is_bridge() ) { bridge_stations.append(tile) }

    local tile_a = tile
    local tile_b = tile

    local set_a = false
    local set_b = false

    // first loop check
    local tile_start = true

    local no_remove = false
    local check_slope_slope_a = null
    local check_slope_slope_b = null

    //gui.add_message_at(pl, "# tile.get_slope() " + tile.get_slope(), world.get_time())

    do
    {

      if ( !set_a ) {
        tile_a = tile_x(tile_a.x - dir_x, tile_a.y - dir_y, tile_a.z)

        //gui.add_message_at(pl, coord3d_to_string(tile_a) + " ## tile_a.is_ground() " + tile_a.is_ground() + " tile_a.is_bridge() " + tile_a.is_bridge() + " tile_a.get_way(wt) " + tile_a.get_way(wt), world.get_time())
        //gui.add_message_at(pl, " tile_a.is_valid() **** " + tile_a.is_valid(), world.get_time())

        if ( tile_a.get_way(wt) == null && !tile_start ) {
          tile_a = square_x(tile_a.x, tile_a.y).get_ground_tile()
        } else if ( tile_a.get_way(wt) == null && tile_start ) {
          if ( tile_x(tile_a.x, tile_a.y, tile_a.z + 1).get_way(wt) != null ) {
            tile_a = tile_x(tile_a.x, tile_a.y, tile_a.z + 1)
          } else if ( tile_x(tile_a.x, tile_a.y, tile_a.z + 2).get_way(wt) != null ) {
            tile_a = tile_x(tile_a.x, tile_a.y, tile_a.z + 2)
          }
        }
        //gui.add_message_at(pl, " tile_a **** " + coord3d_to_string(tile_a), world.get_time())
      }

      //gui.add_message_at(pl, coord3d_to_string(tile_b) + " tile_b.get_way(wt) " + tile_b.get_way(wt), world.get_time())
      if ( !set_b ) {
        tile_b = tile_x(tile_b.x + dir_x, tile_b.y + dir_y, tile_b.z)
        if ( tile_b.get_way(wt) == null && !tile_start ) {
          tile_b = square_x(tile_b.x, tile_b.y).get_ground_tile()
        } else if ( tile_b.get_way(wt) == null && tile_start ) {
          if ( tile_x(tile_b.x, tile_b.y, tile_b.z + 1).get_way(wt) != null ) {
            tile_b = tile_x(tile_b.x, tile_b.y, tile_b.z + 1)
          } else if ( tile_x(tile_b.x, tile_b.y, tile_b.z + 2).get_way(wt) != null ) {
            tile_b = tile_x(tile_b.x, tile_b.y, tile_b.z + 2)
          }
        }
        //gui.add_message_at(pl, " tile_b ****" + coord3d_to_string(tile_b), world.get_time())
      }

      // check slope - slope
      local t0 = tile_a
      local t1 = tile_x(tile_a.x + dir_x, tile_a.y + dir_y, tile_a.z)
      check_slope_slope_a = test_bridge_end(pl, t0, t1, wt)
      //gui.add_message_at(pl, " check_slope_slope tile_a " + check_slope_slope_a, t0)


      if ( ( !tile_a.is_bridge() || check_slope_slope_a ) && !set_a ) {
        if ( !set_b && check_slope_slope_a == null ) { tile = tile_a }

        local b0 = square_x(tile_a.x + dir_x, tile_a.y + dir_y).get_ground_tile()
        //  gui.add_message_at(pl, tile_a.z + " test " + b0.z + " b0.get_slope() " + b0.get_slope(), b0)
        local a0 = square_x(tile_a.x, tile_a.y).get_ground_tile()
        if ( a0.z > b0.z && b0.get_slope() == 0 ) {
          //gui.add_message_at(pl, " test no_remove ", b0)
          no_remove = true
        } else {
          tile_a = square_x(tile_a.x + dir_x, tile_a.y + dir_y).get_ground_tile()
          bridge_coord.append(tile_a)

          // coord for restor catenary
          catenary_coord.append(square_x(tile_a.x, tile_a.y).get_ground_tile())

          if ( !check_slope_slope_a ) { set_a = true }

        }
      }

      // check slope - slope
      t0 = tile_b
      t1 = tile_x(tile_b.x - dir_x, tile_b.y - dir_y, tile_b.z)
      check_slope_slope_b = test_bridge_end(pl, t0, t1, wt)
      //gui.add_message_at(pl, " check_slope_slope tile_b " + check_slope_slope_b, t0)

      if ( ( !tile_b.is_bridge() || check_slope_slope_b ) && !set_b ) {
        if ( !set_a && check_slope_slope_b == null ) { tile = tile_b }

        local b0 = square_x(tile_b.x - dir_x, tile_b.y - dir_y).get_ground_tile()
        //  gui.add_message_at(pl, tile_b.z + " test " + b0.z + " b0.get_slope() " + b0.get_slope(), b0)
        local a0 = square_x(tile_a.x, tile_a.y).get_ground_tile()
        if ( a0.z > b0.z && b0.get_slope() == 0 ) {
          //gui.add_message_at(pl, " test no_remove ", b0)
          no_remove = true
        } else {
          tile_b = square_x(tile_b.x - dir_x, tile_b.y - dir_y).get_ground_tile()
          bridge_coord.append(tile_b)

          // coord for restor catenary
          catenary_coord.append(square_x(tile_b.x, tile_b.y).get_ground_tile())

          if ( !check_slope_slope_b ) { set_b = true }

        }
      }


      // check stations
      if ( tile_a.find_object(mo_building) != null && tile_a.is_bridge() ) { bridge_stations.append(tile_a) }
      if ( tile_b.find_object(mo_building) != null && tile_b.is_bridge() ) { bridge_stations.append(tile_b) }

      // check signal
      sign_desc = tile_a.find_object(mo_signal)
      if ( sign_desc != null && tile_a.is_bridge() ) {
        local sign_data = []
        sign_data.append(tile_a)
        // ribi
        sign_data.append(tile_a.get_way_dirs_masked(wt))
        // signal
        sign_data.append(sign_desc.get_desc())

        sign_pos.append(sign_data)
      }
      sign_desc = tile_b.find_object(mo_signal)
      if ( sign_desc != null && tile_b.is_bridge() ) {
        local sign_data = []
        sign_data.append(tile_b)
        // ribi
        sign_data.append(tile_b.get_way_dirs_masked(wt))
        // signal
        sign_data.append(sign_desc.get_desc())

        sign_pos.append(sign_data)
      }

      if ( tile_start ) { tile_start = false }

      if ( no_remove ) { break }

    } while(bridge_coord.len()<2)

    //if ( check_slope_slope == null ) { return }

    //gui.add_message_at(pl, " bridge from " + coord3d_to_string(bridge_coord[0]) + " to " + coord3d_to_string(bridge_coord[1]), world.get_time())

    if ( no_remove ) {
      return gui.add_message_at(pl, translate("Bridge too complex for automatic replacement!"), world.get_time())
    }

    if ( bridge_coord[0].x == bridge_coord[1].x && bridge_coord[0].y == bridge_coord[1].y ) {
      return gui.add_message_at(pl, " ERROR - bridge not correct found", world.get_time())
    }
    //gui.add_message_at(pl, " catenary from " + coord3d_to_string(tile_a) + " to " + coord3d_to_string(tile_b), world.get_time())

    // select new objects
    local speed = tile.find_object(mo_way).get_desc().get_topspeed()
    //gui.add_message_at(pl, coord3d_to_string(tile) + " speed  " + speed, world.get_time())
    //gui.add_message_at(pl, coord3d_to_string(tile) + " speed_old  " + speed_old, world.get_time())
    // way
    local way_obj = tile.find_object(mo_way).get_desc() //way_list[0]
    if ( !way_obj.is_available(world.get_time()) ) {
      way_obj = find_object(pl, "way", wt, way_obj.get_topspeed())
    }
    //gui.add_message_at(pl, " select way " + way_obj.get_name(), world.get_time())
    // catenary
    local catenary_obj = null
    if ( tile.find_object(mo_wayobj) != null ) {
      catenary_obj = tile.find_object(mo_wayobj).get_desc()
      if ( catenary_obj != null && !catenary_obj.is_available(world.get_time()) ) {
        catenary_obj = find_object(pl, "catenary", wt, catenary_obj.get_topspeed())
      }
      //gui.add_message_at(pl, " select catenary " + catenary_obj.get_name(), world.get_time())

    }

    local station_tiles = null
    local remove_station = true
    local stations_name = ""
    local station_obj = null
    local build_station_obj = []
    /*
     * station_type
     * 0 = single station on bridge
     */
    local station_type = 0

    if ( bridge_stations.len() > 0 ) {
      station_tiles = bridge_stations[0].get_halt().get_tile_list()

      if ( station_tiles.len() > bridge_stations.len() ) {
        remove_station = false
      } else if ( station_tiles.len() == bridge_stations.len() ) {
        //bridge_stations[0].find_object(mo_building)
        local old_halt_obj = bridge_stations[0].get_halt()
        stations_name = old_halt_obj.get_name()
        //station_obj = bridge_stations[0].find_object(mo_building).get_desc()

        //gui.add_message_at(pl, " enables_pax() " + bridge_stations[0].find_object(mo_building ).get_desc().enables_pax(), world.get_time())
        for ( local i = 0; i < bridge_stations.len(); i++ ) {
          station_obj = find_station(wt, good_desc_x("none"), bridge_stations[i].find_object(mo_building).get_desc().get_capacity(), bridge_stations[i].find_object(mo_building).get_desc().get_name(), "name")
          gui.add_message_at(pl, " bridge_stations["+i+"] " + bridge_stations[i].find_object(mo_building).get_desc().get_name(), world.get_time())
          if ( station_obj != null ) {
            gui.add_message_at(pl, " station_obj " + station_obj.get_name(), world.get_time())
            build_station_obj.append(station_obj)
          } else {
            // search new station by nothing station_obj
            gui.add_message_at(pl, " station_obj null: " + station_obj, world.get_time())

            // no station object not remove bridge
            if ( station_obj == null ) {
              remove_station = false
            }
          }
        }


        if ( bridge_stations[0].find_object(mo_building ).get_desc().enables_pax() ) {
        }

        // enables_freight()

      }


    }


    local bridge_obj = find_object(pl, "bridge", wt, speed, bridge_coord.len())
    // no bridge found to way speed
    if ( bridge_obj == null ) {
      // search higher speed bridge
      bridge_obj = find_object(pl, "bridge", wt, speed_old+1, bridge_coord.len())
    }

    //if ( bridge_obj != null ) { gui.add_message_at(pl, " select bridge " + bridge_obj.get_name(), world.get_time()) }

    //local tile_s = tile_x(bridge_coord[0].x, bridge_coord[0].y, bridge_coord[0].z)
    //local tile_e = tile_x(bridge_coord[1].x, bridge_coord[1].y, bridge_coord[1].z)

    // check brigde end fields
    // bridge_coord[0], bridge_coord[1]
/*
    gui.add_message_at(pl, " bridge_coord[0].z " + bridge_coord[0].z, bridge_coord[0])
    gui.add_message_at(pl, " b0.z " + b0, world.get_time())
    gui.add_message_at(pl, " b0.get_slope() " + b0.get_slope(), world.get_time())
    gui.add_message_at(pl, " bridge_coord[1].z " + bridge_coord[1].z, bridge_coord[1])
    gui.add_message_at(pl, " b1.z " + b1, world.get_time())
    gui.add_message_at(pl, " b1.get_slope() " + b1.get_slope(), world.get_time())

    gui.add_message_at(pl, " bridge_coord.len() " + bridge_coord.len(), world.get_time())
*/

    local b1 = square_x(bridge_coord[1].x, bridge_coord[1].y).get_ground_tile()
    if ( bridge_coord[1].z > b1.z && b1.get_slope == 0 ) {
      no_remove = true
      gui.add_message_at(pl, " bridge_coord[1] no_remove ", bridge_coord[1])
    }


    //gui.add_message_at(pl, " bridge_stations.len() " + bridge_stations.len(), world.get_time())
    if ( speed_old < speed && remove_station && bridge_obj != null && !no_remove ) {
      // remove signals
      //gui.add_message_at(pl, " sign_pos.len() " + sign_pos.len(), world.get_time())
      if ( sign_pos.len() > 0 ) {
        local tool = command_x(tool_remover)
        local sign_data = null
        local err = null
        for (local i = 0; i < sign_pos.len(); i++ ) {
          //gui.add_message_at(pl, " sign_pos["+i+"] " + sign_pos[i].len(), world.get_time())
          sign_data = sign_pos[i]
          err = tool.work(pl, sign_data[0])

        }
      }
      // remove exists bridge
      local tool = command_x(tool_remove_way)
      local err = null

      if ( sign_pos.len() == 0 ) {
        err = tool.work(pl, bridge_coord[0], bridge_coord[1], "" + wt)
        if ( err != null ) {
          gui.add_message_at(pl, " ERROR " + err, world.get_time())
        }
      } else {
        local sign_data = sign_pos[0]
        //gui.add_message_at(pl, " signal ribi " + sign_data[1], world.get_time())
        if ( sign_data[1] == 1 || sign_data[1] == 4 ) {
          err = tool.work(pl, bridge_coord[0], bridge_coord[1], "" + wt)
        } else if ( sign_data[1] == 4 || sign_data[1] == 8 ) {
          err = tool.work(pl, bridge_coord[1], bridge_coord[0], "" + wt)
        } else {
          // ribi 5 or 10
          err = tool.work(pl, bridge_coord[0], bridge_coord[1], "" + wt)
        }
        if ( err != null ) {
          gui.add_message_at(pl, " ERROR " + err, world.get_time())
        }
      }
      // build new bridge
      err = null
      err = command_x.build_bridge(pl, bridge_coord[0], bridge_coord[1], bridge_obj)

      // restore catenary
      if ( catenary_obj != null ) {
        command_x.build_wayobj(pl, catenary_coord[0], catenary_coord[1], catenary_obj)
      }

      // restore signals
      //gui.add_message_at(pl, " sign_pos.len() " + sign_pos.len(), world.get_time())
      if ( sign_pos.len() > 0 ) {
        for (local i = 0; i < sign_pos.len(); i++ ) {
          //gui.add_message_at(pl, " sign_pos["+i+"] " + sign_pos[i].len(), world.get_time())
          local sign_data = sign_pos[i]
          /*gui.add_message_at(pl, " sign_data.len() " + sign_data.len(), world.get_time())
          gui.add_message_at(pl, " sign_data[0] " + coord3d_to_string(tile_x(sign_data[0].x, sign_data[0].y, sign_data[0].z)), world.get_time())
          gui.add_message_at(pl, " sign_data[1] " + sign_data[1], world.get_time())
          gui.add_message_at(pl, " sign_data[2] " + sign_data[2].get_name(), world.get_time())
          */

          if ( sign_data[0].x == bridge_coord[0].x && sign_data[0].y == bridge_coord[0].y ) {
            sign_data[0].z = bridge_coord[0].z
          } else if ( sign_data[0].x == bridge_coord[1].x && sign_data[0].y == bridge_coord[1].y ) {
            sign_data[0].z = bridge_coord[1].z
          }

            local list = sign_desc_x.get_available_signs(wt)
            local obj_sign = null
            foreach(o in list) {
              //gui.add_message_at(pl, " o.get_name() " + o.get_name(), world.get_time())
              if (o.get_name() == sign_data[2].get_name()) {
                //obj_sign = o
                //gui.add_message_at(pl, " signal found ", world.get_time())
                break
              }
            }

          //local tile = tile_x(sign_data[0].x, sign_data[0].y, sign_data[0].z)
          //gui.add_message_at(pl, " signal found " + coord3d_to_string(tile), world.get_time())
            local ribi = null
            do {
              local err = command_x.build_sign_at(pl, sign_data[0], sign_data[2])
              ribi = sign_data[0].get_way_dirs_masked(wt)
              //if (ribi == sign_data[1])
               // break
            } while (ribi != sign_data[1])

        }
      }

      // restore stations
      if ( remove_station && station_obj != null ) {
        if ( station_type == 0 ) {
          for ( local i = 0; i < station_tiles.len(); i++ ) {
            err = command_x.build_station(pl, bridge_stations[i], build_station_obj[i])
          }
          bridge_stations[0].get_halt().set_name(stations_name)
        }

      }


    } else {
      local output_message = null
      if ( bridge_stations.len() > 0 ) {
        output_message = translate("Bridges with stations are not replaced.")
      } else if ( no_remove ) {
        output_message = translate("Bridge too complex for automatic replacement!")
      } else {
        if ( bridge_obj == null ) {
          output_message = translate("No bridge found.")
        } else {
          output_message = translate("Speed of the bridge equal to or higher than the speed of the adjacent track.")
        }
      }
      return gui.add_message_at(pl, output_message, world.get_time())
    }

  } else {
    local output_message = translate("The field does not belong to any bridge.")
    return gui.add_message_at(pl, output_message, world.get_time())
  }
}

/**
  * find object tool
  *
  * obj   = object type ( bridge, tunnel, way, catenary )
  * wt    = waytype
  * speed = speed
  */
function find_object(pl, obj, wt, speed, bridge_len = 2) {

  local list = null
  switch(obj) {
    case "bridge":
      list = bridge_desc_x.get_available_bridges(wt)
      break
    case "tunnel":
      list = tunnel_desc_x.get_available_tunnels(wt)
      break
    case "way":
      list = way_desc_x.get_available_ways(wt, st_flat)
      break
    case "catenary":
      list = wayobj_desc_x.get_available_wayobjs(wt)
      break
  }


  // sort objects by speed and remove to low speed
  {

    local sort_obj_list = []
    local check_length = true

    //gui.add_message_at(pl, i + " - obj " + list[i] + " length = " + list[i].get_max_length() , world.get_time())
    for (local j=0; j < list.len(); j++) {
      // check bridge length
      if ( obj == "bridge" && ( bridge_len <= list[j].get_max_length() || list[j].get_max_length() == 0 ) ) {
        check_length = true
      } else if ( obj == "bridge" ) {
        check_length = false
      }
      if ( check_length && speed <= list[j].get_topspeed() && sort_obj_list.find(list[j]) == null ) {
        if ( sort_obj_list.len() == 0 ) {
          sort_obj_list.append(list[j])
        } else {
          for(local i=0; i<sort_obj_list.len(); i++) {
            if ( list[j].get_topspeed() < sort_obj_list[i].get_topspeed() ) {
              sort_obj_list.insert(i, list[j])
              break
            }
          }
        }
      }
    }

    list.clear()
    list.extend(sort_obj_list)
    /*for(local i=0; i<list.len(); i++) {
      gui.add_message_at(pl, i + " obj " + list[i].get_name() + " speed " + list[i].get_topspeed(), world.get_time())
    }*/
  }

  local obj_desc = null

  if (list.len()>0) {
    obj_desc = list[0]
    //gui.add_message_at(pl, "0  obj_desc " + obj_desc.get_name(), world.get_time())

      for(local i=1; i<list.len(); i++) {
        local b = list[i]
        local o = 1
        //gui.add_message_at(pl, i + "  b " + b.get_name(), world.get_time())
        if ( obj == "bridge" && b.get_max_length() < bridge_len ) {
          //o = 0
        }

        if ( (obj == "way" || obj == "tunnel") && !obj_desc.is_available(world.get_time()) ) {
          //o = 0
        }

        if ( obj == "catenary" && obj_desc.is_overhead_line() ) { //&& !obj_desc.is_available(world.get_time())
          o = 0
        }

        if ( o == 1 ) {
          if (obj_desc.get_topspeed() <= speed) {
            if ( b.get_topspeed() > obj_desc.get_topspeed() && b.get_topspeed() <= speed ) {
              obj_desc = b
              if ( obj_desc.get_topspeed() == speed ) { break }
            } else {
              if ( obj_desc.get_topspeed() >= speed ) { break }
              obj_desc = b
              //gui.add_message_at(pl, i + " break obj_desc " + obj_desc.get_name(), world.get_time())
              break
            }
          }
        }
      }
  }

  return obj_desc
}

function find_station(wt, good, capacity, obj_name, search_type) {

  local stations_list = null
  local station_obj = null

  if ( search_type == "name" ) {
    stations_list = building_desc_x.get_available_stations(building_desc_x.station, wt, good)
    foreach(o in stations_list) {
      if (o.get_name() == obj_name) {
        station_obj = o
        //gui.add_message_at(pl, " signal found ", world.get_time())
        break
      }

    }
  }

  if ( search_type == "new" ) {

  }



  return station_obj

}

function test_bridge_end(pl, tile1, tile2, wt) {


  if ( tile1.is_ground() && tile1.is_bridge() && !tile2.is_bridge() ) {
    //gui.add_message_at(pl, coord3d_to_string(tile1) + " ## tile1.is_ground() " + tile1.is_ground() + " tile1.is_bridge() " + tile1.is_bridge(), world.get_time())
    // + " tile1.get_way(wt) " + tile1.get_way(wt)
    return false
  }  //+ " tile1.get_way(wt) " + tile1.get_way(wt)

  if ( tile1.get_way_dirs(wt) == tile2.get_way_dirs(wt) ) {

    local b1 = square_x(tile1.x, tile1.y).get_ground_tile()
    local b2 = square_x(tile2.x, tile2.y).get_ground_tile()

      //gui.add_message_at(pl, tile1.z + " test " + b1.z + " b1.get_slope() " + b1.get_slope(), b1)
      //gui.add_message_at(pl, tile2.z + " test " + b2.z + " b2.get_slope() " + b2.get_slope(), b2)

    if ( (tile1.z > b1.z && b1.get_slope() > 0) && (tile2.z > b2.z && b2.get_slope() > 0) ) {
      //gui.add_message_at(pl, " test slope ", b1)

      return true
    }

    //gui.add_message_at(pl, " test_bridge_end check way dirs  ", world.get_time())


  } else {
    return false
  }

  return null
}
