include("../sq_toolkit/astar")  // .. route search for way building etc

function is_valid_pos(pl, pos, start)
{
  print("is_valid_pos() called. " + pl.get_name() + "," + pos + ", " + start)
  return 2
}

/**
 * return error message
 */
function do_work(pl, start, end)
{
  local our_player = player_x.nr

  if ( coord3d_to_string(start) == coord3d_to_string(end) ) {
    return
  } /*else {
    local output_message = format(translate("upgrade way from %s to %s"), coord3d_to_string(start), coord3d_to_string(end))
    gui.add_message_at(pl, output_message, world.get_time())
  }*/

  local t_start      = tile_x(start.x, start.y, start.z)
  local t_end        = tile_x(end.x, end.y, end.z)
  local w_object     = t_start.find_object(mo_way)
  local catenary_obj = t_start.find_object(mo_wayobj)
  local catenary_new = 0
  local wt           = null
  local speed        = 0
  local way_new      = null
  local wayline      = []
  local bridges      = []
  local tunnel       = []
  local build_count  = 0

  if ( w_object == null || t_end.find_object(mo_way) == null ) {
    local output_message = translate("no way found")
    gui.add_message_at(pl, output_message, world.get_time())
    return

  }

  if ( w_object != null ) {
    wt = w_object.get_waytype()
    speed = w_object.get_max_speed()

    way_new = find_object(pl, "way", wt, speed)

    if ( w_object.is_electrified() ) {
      local electr_speed = way_new.get_topspeed()
      if ( catenary_obj.get_desc().get_topspeed() < electr_speed ) {
        catenary_obj = find_object(pl, "catenary", wt, electr_speed)
        catenary_new = 1
      }
    }

    local output_message = format(translate("upgrade way from %s to %s"), coord3d_to_string(start), coord3d_to_string(end))
    gui.add_message_at(pl, output_message, world.get_time())

  }


  if ( wt != null ) {
    local asf = astar_route_finder(wt)
    local result = asf.search_route([t_start], [t_end])

    if ( "err" in result ) {

      local output_message = translate("no route found")
      return gui.add_message_at(pl, output_message, world.get_time())

    } else {
      local bc = 0
      local tc = 0
      foreach(node in result.routes) {
        local tile = tile_x(node.x, node.y, node.z)
        if ( tile.find_object(mo_way).get_max_speed() <= speed && tile.find_object(mo_tunnel) == null ) {
          wayline.append(tile)
        }
          if ( tile.find_object(mo_bridge) == null ) {
            bc = 0
          }
          if ( tile.find_object(mo_tunnel) == null ) {
            tc = 0
          }
        if ( tile.find_object(mo_bridge) != null && bc == 0 ) {
          bridges.append(tile)
          bc = 1
        }
        if ( tile.find_object(mo_tunnel) != null && tc == 0 ) {
          tunnel.append(tile)
          tc = 1
        }
      }
      wayline.reverse()
    }

  }

  if ( wayline.len() > 0 ) {

    if ( way_new.get_topspeed() > speed ) {

      local build_cost = (wayline.len() * way_new.get_cost())/100
      local maintenance = pl.get_current_maintenance()/100
      local cash = pl.get_current_cash()

      local cash_check = cash-(maintenance*5)-build_cost

      //local output_message = " new way cost: " + build_cost + "  cash_check: " + cash_check
      //gui.add_message_at(pl, output_message, world.get_time())

      if ( cash_check < 0 ) {
        local output_message = format(translate("upgrade way build cost to high: %d"), cash_check)
        return gui.add_message_at(pl, output_message, world.get_time())

      } else {
        local err = null
        for ( local i = 1; i < wayline.len(); i++ ) {

          local xt = abs(wayline[i-1].x - wayline[i].x)
          local yt = abs(wayline[i-1].y - wayline[i].y)

          local way_owner = wayline[i].get_way(wt).get_owner()
          //gui.add_message_at(pl, " way_owner : " + way_owner, wayline[i])
          //gui.add_message_at(pl, xt + " xt : " + yt + " yt", wayline[i])

          if ( xt < 2 && yt < 2 && (way_owner.nr == pl.nr || way_owner.nr == 1) ) {
            err = command_x.build_way(pl, wayline[i-1], wayline[i], way_new, true)
            if ( err != null ) {
              local output_message = " err: " + err
              gui.add_message_at(pl, output_message, wayline[i])
              err = null
            } else {
              build_count++
            }

          }
        }

        if ( catenary_new == 1 ) {
          command_x.build_wayobj(pl, t_start, t_end, catenary_obj)
        }

      }

    }
  }

  // output bridges
  if ( bridges.len() > 0 ) {
    for ( local i = 0; i < bridges.len(); i++ ) {
      local t = tile_x(bridges[i].x, bridges[i].y, bridges[i].z)
      local bspeed = t.find_object(mo_bridge).get_desc().get_topspeed()
      local output_message = format(translate("bridge found at tile %s with %d km/h"), coord3d_to_string(bridges[i]), bspeed)
      gui.add_message_at(pl, output_message, bridges[i])
    }
  }

  // output tunnel
  if ( tunnel.len() > 0 ) {
    for ( local i = 0; i < tunnel.len(); i++ ) {
      local t = tile_x(tunnel[i].x, tunnel[i].y, tunnel[i].z)
      local tspeed = tunnel[i].find_object(mo_tunnel).get_desc().get_topspeed()
      local output_message = format(translate("tunnel found at tile %s with %d km/h"), coord3d_to_string(tunnel[i]), tspeed)
      gui.add_message_at(pl, output_message, tunnel[i])
    }
  }

  local obj_name = translate(way_new.get_name()) + " " + way_new.get_topspeed() + " km/h"
  local output_message = format(translate("finish upgrade %d way tiles to new way: %s"), build_count, obj_name)

  return gui.add_message_at(pl, output_message, world.get_time())
}

/**
  * find object tool
  *
  * obj   = object type ( bridge, tunnel, way, catenary )
  * wt    = waytype
  * speed = speed
  */
function find_object(pl, obj, wt, speed) {

  local list = []
  switch(obj) {
    case "bridge":
      list = bridge_desc_x.get_available_bridges(wt)
      break
    case "tunnel":
      list = tunnel_desc_x.get_available_tunnels(wt)
      break
    case "way":
      list = way_desc_x.get_available_ways(wt, st_flat)
      break
    case "catenary":
      local li = wayobj_desc_x.get_available_wayobjs(wt)
      for (local j=0; j<li.len(); j++) {
        if ( li[j].is_overhead_line() ) {
            list.append(li[j])
        }
      }
      break
  }

  local len = list.len()

  // sort objects by speed
  {
    local obj_list = []
    for(local i=0; i<len; i++) {
      obj_list.append(list[i].get_topspeed())
    }
    obj_list.sort()

    local sort_obj_list = []

    for(local i=0; i<len; i++) {
      //gui.add_message_at(pl,i + " obj " + obj_list[i] , world.get_time())
      for (local j=0; j<len; j++) {
        if ( obj_list[i] == list[j].get_topspeed() ) {
          sort_obj_list.append(list[j])
        }
      }
    }
    //if ( obj == "way" ) {
      list.clear()
      list = sort_obj_list.slice(0)

    //}
    /*for(local i=0; i<len; i++) {
      gui.add_message_at(our_player,i + " obj " + list[i].get_name() + " speed " + list[i].get_topspeed(), world.get_time())
    }*/
  }

  local obj_desc = null

  if (len>0) {
    obj_desc = list[0]
    //gui.add_message_at(pl, "0  obj_desc " + obj_desc.get_name(), world.get_time())

      for(local i=1; i<len; i++) {
        local b = list[i]
        local o = 1
        //gui.add_message_at(pl, i + "  b " + b.get_name(), world.get_time())
        //gui.add_message_at(pl, i + "   " + obj_desc.is_available(world.get_time()), world.get_time())
        if ( obj == "bridge" && b.get_max_length() < min_len ) {
          o = 0
        }

        if ( o == 1 ) {
          if (obj_desc.get_topspeed() <= speed) {
            obj_desc = b
          } else {
            if ( b.get_topspeed() < obj_desc.get_topspeed()) { // && b.get_topspeed() <= speed
              obj_desc = b
              //if ( obj_desc.get_topspeed() == speed ) { break }
            } else {
              //if ( obj_desc.get_topspeed() >= speed ) { break }
              //obj_desc = b
              //gui.add_message_at(player_x(1), i + " break obj_desc " + obj_desc.get_name(), world.get_time())
             // break
            }
          }
        }
      }
  }

  return obj_desc
}
